/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import cz.insophy.inplan.planning.mokos.AbstractPlanningScorer;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.shop.Workplace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TightRebuildScorer
extends AbstractPlanningScorer<Long> {
    private static final Logger log = LoggerFactory.getLogger(TightRebuildScorer.class);
    private static final String WORKPLACE_PROPERTY = "tight_rebuild_horizon";
    private long tightRebuildHorizon;

    public TightRebuildScorer() {
        super("tight_rebuild_score");
        this.setTightRebuildHorizonDays(7);
    }

    public int getTightRebuildHorizonDays() {
        return (int)(this.tightRebuildHorizon / 86400000L);
    }

    public long getTightRebuildHorizon() {
        return this.tightRebuildHorizon;
    }

    public void setTightRebuildHorizonDays(int tightRebuildHorizonDays) {
        this.tightRebuildHorizon = (long)tightRebuildHorizonDays * 86400000L;
    }

    public void setTightRebuildHorizon(long value) {
        this.tightRebuildHorizon = value;
    }

    @Override
    protected Long getPlanningScore(Operation op, Operation.OperationPlanning planning) {
        Long res = 0L;
        Integer sameRebuildScore = (Integer)planning.getProperty("same_rebuild_score");
        Long tightDueDate = (Long)planning.getProperty("tight_date_score");
        if (sameRebuildScore != null && tightDueDate != null) {
            long trh;
            Workplace wp = Util.getFirstPlannedWa(planning).getWorkplace();
            Long trhProp = (Long)wp.getProperty(WORKPLACE_PROPERTY);
            long l = trh = trhProp != null ? trhProp : this.tightRebuildHorizon;
            if (-tightDueDate.longValue() <= trh) {
                res = sameRebuildScore.longValue();
            }
        } else {
            log.warn("SAME_REBUILD_SCORE or TIGHT_DATE_SCORE not defined for operation {}", (Object)op);
        }
        return res;
    }
}

